<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Proses Data Servis</title>
    <!-- Bootstrap CSS -->
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            font-family: Arial, sans-serif;
            padding-top: 20px;
            background-color: #f8f9fa;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
        .form-group {
            margin-bottom: 20px;
        }
        .table {
            margin-top: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Header dan info servis -->
        <div class="text-center mb-4">
            <h2>Proses Data Servis</h2>
        </div>
        <div class="mb-4">
            <strong>Nama Pelanggan:</strong> <?= $data['servis']['NAMA_PEL']; ?><br>
            <strong>Nama Barang:</strong> <?= $data['servis']['NAMABRG']; ?><br>
            <strong>Keluhan:</strong> <?= $data['servis']['KELUHAN']; ?><br>
        </div>

        <div class="row">
            <!-- Form untuk menambah detail servis -->
            <div class="col-md-6">
                <h3>Tambah Detail Servis</h3>
                
                <form id="formTambahDetail" action="<?= BASEURL; ?>/servis/tambahDetail" method="post">
                    <input type="hidden" name="IDSERVIS" value="<?= $data['servis']['IDSERVIS']; ?>">
                    <div class="form-group">
                        <label for="IDPEN">Penanganan</label>
                        <select class="form-control" id="IDPEN" name="IDPEN">
                            <?php foreach ($data['penanganan'] as $penanganan) : ?>
                                <option value="<?= $penanganan['IDPEN']; ?>" data-harga="<?= $penanganan['HARGA']; ?>">
                                    <?= $penanganan['NAMA_PEN']; ?> - Rp<?= number_format($penanganan['HARGA'], 0, ',', '.'); ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="BANYAKNYA">Banyaknya</label>
                        <input type="number" class="form-control" id="BANYAKNYA" name="BANYAKNYA">
                    </div>
                    <div class="form-group">
                        <label for="JUMLAH">Jumlah</label>
                        <input type="number" class="form-control" id="JUMLAH" name="JUMLAH" readonly>
                    </div>
                    <button type="submit" class="btn btn-primary">Tambah Detail</button>
                </form>
            </div>

            <!-- Tabel untuk menampilkan detail servis -->
            <div class="col-md-6">
                <h3>Detail Servis</h3>
                <div class="table-responsive">
                    <table class="table table-bordered">
                        <thead class="thead-light">
                            <tr>
                                <th>Nama Penanganan</th>
                                <th>Banyaknya</th>
                                <th>Jumlah</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php if (isset($data['detailservis']) && is_array($data['detailservis'])): ?>
                            <?php foreach ($data['detailservis'] as $detail) : ?>
                                <tr>
                                    <td><?= isset($detail['NAMA_PEN']) ? $detail['NAMA_PEN'] : ''; ?></td>
                                    <td><?= isset($detail['BANYAKNYA']) ? $detail['BANYAKNYA'] : ''; ?></td>
                                    <td><?= isset($detail['JUMLAH']) ? 'Rp' . number_format($detail['JUMLAH'], 0, ',', '.') : ''; ?></td>
                                    <td>
                                        <form action="<?= BASEURL; ?>/servis/hapusDetailServis" method="post">
                                        <input type="hidden" name="IDSERVIS" value="<?= $data['servis']['IDSERVIS']; ?>">
                                        <input type="hidden" name="IDPEN" value="<?= $detail['IDPEN']; ?>">
                                        <button type="submit" class="btn btn-danger btn-sm">Hapus</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Footer dan link kembali -->
        <div class="text-center mt-4">
            <a href="<?= BASEURL; ?>/servis" class="btn btn-primary">Kembali</a>
            <a href="<?= BASEURL; ?>/servis/cetakNota/<?= $data['servis']['IDSERVIS']; ?>" target="_blank" class="btn btn-success">Cetak Nota</a>
        </div>
    </div>

    <!-- Script JavaScript -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const selectPenanganan = document.getElementById('IDPEN');
            const inputBanyaknya = document.getElementById('BANYAKNYA');
            const inputJumlah = document.getElementById('JUMLAH');

            selectPenanganan.addEventListener('change', function() {
                hitungJumlah();
            });

            inputBanyaknya.addEventListener('input', function() {
                hitungJumlah();
            });

            function hitungJumlah() {
                const harga = parseFloat(selectPenanganan.options[selectPenanganan.selectedIndex].getAttribute('data-harga'));
                const banyaknya = parseFloat(inputBanyaknya.value);

                if (!isNaN(harga) && !isNaN(banyaknya)) {
                    const jumlah = harga * banyaknya;
                    inputJumlah.value = jumlah;
                } else {
                    inputJumlah.value = '';
                }
            }
        });
    </script>

    <!-- Bootstrap JS (diperlukan jika Anda menggunakan fitur tertentu dari Bootstrap seperti dropdown, dll) -->
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
