<div class="container mt-3">
    <div class="row">
        <div class="col-12 mb-3">
            <?php Flashnotif::notif(); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <h4 class="mb-3">Daftar servis</h4>
            <button type="button" class="btn btn-primary mb-3 tambahDatasrv" data-bs-toggle="modal" data-bs-target="#formservis">
                Tambah Data servis
            </button>
            <table id="servisTable" class="display">
                <thead>
                    <tr>
                        <th>Nama Barang</th>
                        <th>Nama Pelanggan</th>
                        <th>Status</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                $idservis = array_column($data['srv'], 'IDSERVIS');
                array_multisort($idservis, SORT_DESC, $data['srv']);
                ?>

                <?php foreach ($data['srv'] as &$srv) : ?>
                    <?php
                    // Dapatkan informasi pelanggan berdasarkan nomor HP atau ID Pelanggan
                   $nama_pelanggan = '';
                    foreach ($data['pelanggan'] as $p) {
                        if ($p['IDPEL'] == $srv['IDPEL']) {
                            $nama_pelanggan = $p['NAMA_PEL'];
                            break;
                        }
                    }
                    $srv['NAMA_PEL'] = $nama_pelanggan;

                    ?>
                    <tr>
                        <td><strong><?= $srv['NAMABRG']; ?></strong></td>
                        <td><small><?= $srv['NAMA_PEL']; ?></small></td>
                        <td><strong><?= $srv['STATUS']; ?></strong></td>
                        <td>
                            <a href="<?= BASEURL; ?>/servis/proses/<?= $srv['IDSERVIS']; ?>" class="badge bg-secondary text-white text-decoration-none">Proses</a>
                            <a href="<?= BASEURL; ?>/servis/cetaktt/<?= $srv['IDSERVIS']; ?>" target="_blank" class="badge bg-primary text-white text-decoration-none">Cetak Tanda Terima</a>
                            <a href="<?= BASEURL; ?>/servis/edit/<?= $srv['IDSERVIS']; ?>" class="badge bg-success text-white text-decoration-none tampilmodaleditsrv" data-bs-toggle="modal" data-bs-target="#formservis" data-idservis="<?= $srv['IDSERVIS']; ?>">Edit</a>
                            <a href="<?= BASEURL; ?>/servis/hapus/<?= $srv['IDSERVIS']; ?>" class="badge bg-danger text-white text-decoration-none" onclick="return confirm('yakin mau dihapus.?');">Hapus</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table><ul class="list-group">
        </div>
    </div>
</div>

<div class="modal fade" id="formservis" tabindex="-1" aria-labelledby="tmbhsrv" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="tmbhsrv">Tambah Data servis</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="forminputservis" action="<?= BASEURL; ?>/servis/tambah" method="post">
                    <input type="hidden" id="IDSERVIS" name="IDSERVIS">
                    <div class="mb-3">
                        <label for="IDPEL" class="form-label">Pelanggan</label>
                        <select class="form-select" id="idpel" name="IDPEL">
                            <option value="">Pilih Pelanggan</option>
                            <?php foreach ($data['pelanggan'] as $pelanggan) : ?>
                                <option value="<?= $pelanggan['IDPEL']; ?>">
                                    <?= $pelanggan['NAMA_PEL']; ?> - <?= $pelanggan['HP']; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="NAMABRG" class="form-label">Nama Barang</label>
                        <input type="text" class="form-control" id="namabrg" name="NAMABRG">
                    </div>
                    <div class="mb-3">
                        <label for="TGL" class="form-label">Tanggal</label>
                        <input type="date" class="form-control" id="tgl" name="TGL">
                    </div>
                    <div class="mb-3">
                        <label for="KELUHAN" class="form-label">Keluhan</label>
                        <input type="text" class="form-control" id="keluhan" name="KELUHAN">
                    </div>
                    <div class="mb-3">
                    <label for="STATUS" class="form-label">Status</label>
                        <select class="form-select" name="STATUS" id="status" aria-label="Default select example">
                            <option value="Dikerjakan">Dikerjakan</option>
                            <option value="Ready">Ready</option>
                            <option value="Selesai">Selesai</option>
                        </select>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah Data</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    // Menangani klik tombol "Proses"
    document.querySelectorAll('.tombol-proses').forEach(item => {
        item.addEventListener('click', function(event) {
            event.preventDefault();
            // Mengambil nilai ID Servis dari atribut data-idservis
            const IDSERVIS = this.getAttribute('data-idservis');
            // Mengatur nilai ID Servis di formulir
            document.getElementById('IDSERVIS').value = IDSERVIS;
            // Submit formulir secara otomatis
            document.getElementById('forminputservis').submit();
        });
    });
</script>
