<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Cetak Tanda Terima Servis</title>

<style>
    body {
        font-family: Arial, sans-serif;
        padding: 30px;
    }

    /* Header sama seperti nota sebelumnya */
    .header {
        display: flex;
        align-items: center;
        border-bottom: 3px solid #4b2ea4;
        padding-bottom: 10px;
    }

    .header img {
        width: 85px;
        height: auto;
        margin-right: 12px;
    }

    .title {
        font-size: 40px;
        font-weight: bold;
        color: #342c9c;
        margin: 0;
        margin-top: 10px;
    }

    .service-desc {
        font-size: 18px;
        font-weight: bold;
        margin-top: 10px;
    }

    .text-small {
        font-size: 15px;
        line-height: 22px;
    }

    .info {
        margin-top: 20px;
        font-size: 17px;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 25px;
    }

    table th, table td {
        border: 2px solid black;
        padding: 10px;
        font-size: 17px;
    }

    table th {
        background: #f1f1f1;
        font-weight: bold;
        text-align: center;
    }

    @media print {
        body { padding: 0; }
    }
</style>

<script>
    window.onload = function(){
        window.print();
    }
</script>

</head>
<body>

<!-- HEADER -->
<div class="header">
    <img src="/webmk/uploads/logo.png" alt="logo">
    <div>
        <div class="title">tritech solutions©</div>
        <div class="signature">
            Contact Person<br>
            WhatsApp 0895339378491
        </div>
    </div>
</div>



<!-- TANDA TERIMA INFO -->
<div class="service-desc">TANDA TERIMA</div>
<table style="width:100%; font-size:10px; border-collapse:collapse;">
    <tbody>
        <tr style="border:none;">
            <td style="width:70px; padding:3px 0; border:none;"><strong>Nama</strong></td>
            <td style="padding:3px 0; border:none;">: <?= $data['pelanggan']['NAMA_PEL']; ?></td>
        </tr>
        <tr style="border:none;">
            <td style="padding:3px 0; border:none;"><strong>Alamat</strong></td>
            <td style="padding:3px 0; border:none;">: <?= $data['pelanggan']['ALAMAT']; ?></td>
        </tr>
    </tbody>
</table>




<!-- TABEL DETAIL -->
<table>
    <thead>
        <tr>
            <th>Nama Barang</th>
            <th>Keluhan</th>
            <th>Status</th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td><?= $data['servis']['NAMABRG']; ?></td>
            <td><?= $data['servis']['KELUHAN']; ?></td>
            <td><?= $data['servis']['STATUS']; ?></td>
        </tr>
    </tbody>
</table>



</body>
</html>
