<!DOCTYPE html> 
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Proses Data Penjualan</title>

    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">

    <style>
        body {
            font-family: Arial, sans-serif;
            padding-top: 20px;
            background-color: #f8f9fa;
        }
        .container {
            background-color: #fff;
            padding: 20px;
            border-radius: 5px;
            box-shadow: 0 0 10px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>

<div class="container">
    
    <!-- HEADER -->
    <div class="text-center mb-4">
        <h2>Proses Data Penjualan</h2>
    </div>

    <!-- INFORMASI PENJUALAN -->
    <div class="mb-4">
        <strong>Nama Pelanggan:</strong> <?= $data['penjualan']['NAMA_PEL']; ?><br>
        <strong>Tanggal Jual:</strong> <?= $data['penjualan']['TGLJ']; ?><br>
    </div>


    <div class="row">

        <!-- FORM TAMBAH DETAIL PENJUALAN -->
        <div class="col-md-6">
            <h3>Tambah Detail Penjualan</h3>

            <form action="<?= BASEURL; ?>/penjualan/tambahDetail" method="post">
                <input type="hidden" name="IDPENJ" value="<?= $data['penjualan']['IDPENJ']; ?>">

                <div class="form-group">
                    <label for="IDBRG">Barang</label>
                    <select class="form-control" id="IDBRG" name="IDBRG">
                        <?php foreach ($data['barang'] as $barang) : ?>
                            <option value="<?= $barang['IDBRG']; ?>" 
                                data-harga="<?= $barang['HARGA_BRG']; ?>">
                                <?= $barang['NAMA_BRG']; ?> - Rp<?= number_format($barang['HARGA_BRG'], 0, ',', '.'); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>

                <div class="form-group">
                    <label for="BANYAKNYAJ">Banyaknya</label>
                    <input type="number" class="form-control" id="BANYAKNYAJ" name="BANYAKNYAJ">
                </div>

                <div class="form-group">
                    <label for="JUMLAHJ">Jumlah</label>
                    <input type="number" class="form-control" id="JUMLAHJ" name="JUMLAHJ" readonly>
                </div>

                <button type="submit" class="btn btn-primary">Tambah Detail</button>
            </form>
        </div>


        <!-- TABEL DETAIL PENJUALAN -->
        <div class="col-md-6">
            <h3>Detail Penjualan</h3>

            <div class="table-responsive">
                <table class="table table-bordered">
                    <thead class="thead-light">
                        <tr>
                            <th>Nama Barang</th>
                            <th>Banyaknya</th>
                            <th>Jumlah</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>

                    <tbody>
                    <?php foreach ($data['detailpenjualan'] as $detail) : ?>
                        <tr>
                            <td><?= $detail['NAMA_BRG']; ?></td>
                            <td><?= $detail['BANYAKNYAJ']; ?></td>
                            <td>Rp<?= number_format($detail['JUMLAHJ'], 0, ',', '.'); ?></td>

                            <td>
                                <form action="<?= BASEURL; ?>/penjualan/hapusDetailpenjualan" method="post">
                                    <input type="hidden" name="IDPENJ" value="<?= $data['penjualan']['IDPENJ']; ?>">
                                    <input type="hidden" name="IDBRG" value="<?= $detail['IDBRG']; ?>">
                                    <button class="btn btn-danger btn-sm" type="submit">Hapus</button>
                                </form>

                            </td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>

                </table>
            </div>
        </div>

    </div>

    <!-- FOOTER -->
    <div class="text-center mt-4">
        <a href="<?= BASEURL; ?>/penjualan" class="btn btn-primary">Kembali</a>
        <a href="<?= BASEURL; ?>/penjualan/cetakNota/<?= $data['penjualan']['IDPENJ']; ?>" target="_blank" 
           class="btn btn-success">Cetak Nota</a>
    </div>

</div>


<script>
document.addEventListener("DOMContentLoaded", function() {
    const barangSelect = document.getElementById("IDBRG");
    const banyaknyaInput = document.getElementById("BANYAKNYAJ");
    const jumlahInput = document.getElementById("JUMLAHJ");

    function hitungJumlah() {
        const harga = parseFloat(barangSelect.options[barangSelect.selectedIndex].getAttribute("data-harga"));
        const qty = parseFloat(banyaknyaInput.value);

        jumlahInput.value = (!isNaN(harga) && !isNaN(qty)) ? harga * qty : "";
    }

    barangSelect.addEventListener("change", hitungJumlah);
    banyaknyaInput.addEventListener("input", hitungJumlah);
});
</script>

</body>
</html>
