<div class="container mt-3">
    <div class="row">
        <div class="col-12 mb-3">
            <?php Flashnotif::notif(); ?>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <h4 class="mb-3">Daftar Penjualan</h4>

            <button type="button" class="btn btn-primary mb-3 tambahDatapenj" data-bs-toggle="modal" data-bs-target="#formpenjualan">
                Tambah Data Penjualan
            </button>

            <table id="penjualanTable" class="display">
                <thead>
                    <tr>
                        <th>Nama Pelanggan</th>
                        <th>Tanggal</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>

                <?php
                // Cegah error jika $data['penj'] kosong
                $penjualan = isset($data['penj']) ? $data['penj'] : [];

                // Urutkan berdasarkan IDPENJ desc
                if (!empty($penjualan)) {
                    $idList = array_column($penjualan, 'IDPENJ');
                    array_multisort($idList, SORT_DESC, $penjualan);
                }
                ?>

                <?php foreach ($penjualan as $penj): ?>
                    <?php
                        // cari nama pelanggan
                        $nama_pelanggan = '';
                        foreach ($data['pelanggan'] as $p) {
                            if ($p['IDPEL'] == $penj['IDPEL']) {
                                $nama_pelanggan = $p['NAMA_PEL'];
                                break;
                            }
                        }
                    ?>
                    <tr>
                        <td><strong><?= $nama_pelanggan; ?></strong></td>
                        <td><?= $penj['TGLJ']; ?></td>
                        <td>
                            <a href="<?= BASEURL; ?>/penjualan/proses/<?= $penj['IDPENJ']; ?>" 
                                class="badge bg-primary text-white text-decoration-none">Input Barang</a>
                                
                            <a href="<?= BASEURL; ?>/penjualan/edit/<?= $penj['IDPENJ']; ?>" 
                                class="badge bg-success text-white text-decoration-none tampilmodaleditpenj"
                                data-bs-toggle="modal" data-bs-target="#formpenjualan"
                                data-idpenj="<?= $penj['IDPENJ']; ?>">Edit</a>

                            <a href="<?= BASEURL; ?>/penjualan/hapus/<?= $penj['IDPENJ']; ?>" 
                                class="badge bg-danger text-white text-decoration-none"
                                onclick="return confirm('yakin mau dihapus.?');">Hapus</a>
                        </td>
                    </tr>
                <?php endforeach; ?>

                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- MODAL -->
<div class="modal fade" id="formpenjualan" tabindex="-1" aria-labelledby="tambahpenjualan" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Tambah Data Penjualan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>

            <div class="modal-body">
                <form action="<?= BASEURL; ?>/penjualan/tambah" method="post">
                    <input type="hidden" id="IDPENJ" name="IDPENJ">

                    <div class="mb-3">
                        <label class="form-label">Pelanggan</label>
                        <select class="form-select" name="IDPEL" id="idpel">
                            <option value="">Pilih Pelanggan</option>
                            <?php foreach ($data['pelanggan'] as $pel): ?>
                                <option value="<?= $pel['IDPEL']; ?>">
                                    <?= $pel['NAMA_PEL']; ?> - <?= $pel['HP']; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="mb-3">
                        <label class="form-label">Tanggal</label>
                        <input type="date" class="form-control" name="TGLJ">
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Simpan</button>
                    </div>
                </form>
            </div>

        </div>
    </div>
</div>
