<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Cetak Nota Penjualan</title>

<style>
    body {
        font-family: Arial, sans-serif;
        padding: 30px;
    }

    .header {
        display: flex;
        align-items: center;
        border-bottom: 3px solid #4b2ea4;
        padding-bottom: 10px;
    }

    .header img {
        width: 85px;
        height: auto;
        margin-right: 12px;
    }

    .title {
        font-size: 40px;
        font-weight: bold;
        color: #342c9c;
        margin: 0;
        margin-top: 10px;
    }

    .text-small {
        font-size: 15px;
        line-height: 22px;
    }

    .info {
        margin-top: 15px;
        font-size: 16px;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 25px;
    }

    table th, table td {
        border: 2px solid black;
        padding: 10px;
        font-size: 17px;
    }

    table th {
        background: #f1f1f1;
        text-align: center;
        font-weight: bold;
    }

    .total-row th {
        background: white !important;
        border-top: 3px solid black;
        font-size: 18px;
    }

    .signature {
        margin-top: 40px;
        text-align: right;
        font-size: 18px;
        position: relative;
    }

    .logo-bawah {
        width: 110px;
        height: auto;
        margin-top: 5px;
        position: absolute;
        left: 500px;
        bottom: 0;
    }

    @media print {
        body { padding: 0; }
    }
</style>

<script>
    window.onload = function() {
        window.print();
    };
</script>

</head>
<body>

<div class="header">
    <img src="/webmk/uploads/logo.png" alt="logo">
    <div>
        <div class="title">tritech solutions©</div>
        <div class="text-small">
            service & instalasi<br>
            komputer &nbsp;&nbsp; printer &nbsp;&nbsp; proyektor &nbsp;&nbsp; jaringan laptop &nbsp;&nbsp; cctv &nbsp;&nbsp; runningtext &nbsp;&nbsp; dll <br>
            Jl. Sumberwudi Pertigaan Kalitengah Lamongan 0895339378491
        </div>
    </div>
</div>

<div class="info">
    <table style="border: none !important;">
        <tr>
            <td style="border:none; font-size:17px;"><strong>No Nota :</strong> <?= $data['penjualan']['IDPENJ']; ?></td>
            <td style="border:none; text-align:right; font-size:17px;">Lamongan, <?= $data['tanggal_sekarang']; ?></td>
        </tr>
        <tr>
            <td style="border:none; font-size:17px;"><strong>Pelanggan :</strong> <?= $data['penjualan']['NAMA_PEL']; ?></td>
            <td style="border:none;"></td>
        </tr>
    </table>
</div>

<table>
    <thead>
        <tr>
            <th>Nama Barang</th>
            <th>Banyaknya</th>
            <th>Jumlah</th>
        </tr>
    </thead>

    <tbody>
        <?php if (!empty($data['detailpenjualan'])): ?>
            <?php foreach ($data['detailpenjualan'] as $detail): ?>
            <tr>
                <td><?= $detail['NAMA_BRG']; ?></td>
                <td style="text-align:center;"><?= $detail['BANYAKNYAJ']; ?></td>
                <td style="text-align:right;">Rp <?= number_format($detail['JUMLAHJ'], 0, ',', '.'); ?></td>
            </tr>
            <?php endforeach; ?>
        <?php endif; ?>
    </tbody>

    <tr class="total-row">
        <th></th>
        <th>Total</th>
        <th style="text-align:right;">Rp <?= number_format($data['penjualan']['TOTALJ'] ?? 0, 0, ',', '.'); ?></th>
    </tr>
</table>

<div class="signature">
    Hormat kami,<br><br><br>
    <img src="/webmk/uploads/stempeltritech.png" class="logo-bawah" alt="logo"><br>
    tritech solution
</div>

</body>
</html>
