<div class="container mt-3">
    <div class="row">
        <div class="col-12 mb-3">
            <?php Flashnotif::notif(); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <h4 class="mb-3">Daftar penanganan</h4>
            <button type="button" class="btn btn-primary mb-3 tambahDatapngn" data-bs-toggle="modal" data-bs-target="#forminputpngn">
                Tambah Data penanganan
            </button>
            <table id="penangananTable" class="display">
                <thead>
                    <tr>
                        <th>Nama Penanganan</th>
                        <th>Harga</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                // Extract IDPEL for sorting
                $idpen = array_column($data['pngn'], 'IDPEN');

                // Sort $data['plgn'] based on $idpel in descending order
                array_multisort($idpen, SORT_DESC, $data['pngn']);
                ?>

                <?php foreach($data['pngn'] as $pngn) : ?>
                    <tr>
                        <td><strong><?= $pngn['NAMA_PEN']; ?></strong></td>
                        <td><small>Rp<?= number_format($pngn['HARGA'], 0, ',', '.'); ?></small></td>
                        <td>
                            <a href="<?= BASEURL; ?>/penanganan/edit/<?= $pngn['IDPEN']; ?>" class="badge bg-success text-white text-decoration-none tampilmodaleditpngn" data-bs-toggle="modal" data-bs-target="#forminputpngn" data-idpen="<?= $pngn['IDPEN']; ?>">Edit</a>
                            <a href="<?= BASEURL; ?>/penanganan/hapus/<?= $pngn['IDPEN']; ?>" class="badge bg-danger text-white text-decoration-none" onclick="return confirm('yakin mau dihapus.?');">Hapus</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table><ul class="list-group">
        </div>
    </div>
</div>

<div class="modal fade" id="forminputpngn" tabindex="-1" aria-labelledby="tmbhpngn" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="tmbhpngn">Tambah Data penanganan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formpenanganan" action="<?= BASEURL; ?>/penanganan/tambah" method="post">
                    <input type="hidden" id="idpen" name="IDPEN">
                    <div class="mb-3">
                        <label for="NAMA_PEN" class="form-label">Nama penanganan</label>
                        <input type="text" class="form-control" id="nama_pen" name="NAMA_PEN">
                    </div>
                    <div class="mb-3">
                        <label for="HARGA" class="form-label">HARGA</label>
                        <input type="text" class="form-control" id="harga" name="HARGA">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah Data</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>