<div class="container mt-3">
    <div class="row">
        <div class="col-12 mb-3">
            <?php Flashnotif::notif(); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <h4 class="mb-3">Daftar Pelanggan</h4>
            <button type="button" class="btn btn-primary mb-3 tambahData" data-bs-toggle="modal" data-bs-target="#forminputplgn">
                Tambah Data Pelanggan
            </button>
            <table id="pelangganTable" class="display">
                <thead>
                    <tr>
                        <th>Nama</th>
                        <th>Alamat</th>
                        <th>No Hp</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                    // Mengambil IDPEL untuk pengurutan
                    $idpel = array_column($data['plgn'], 'IDPEL');

                    // Mengurutkan $data['plgn'] berdasarkan $idpel secara descending
                    array_multisort($idpel, SORT_DESC, $data['plgn']);
                ?>

                <?php foreach($data['plgn'] as $plgn) : ?>
                    <tr>
                        <td><strong><?= $plgn['NAMA_PEL']; ?></strong></td>
                        <td><small><?= $plgn['ALAMAT']; ?></small></td>
                        <td><small><?= $plgn['HP']; ?></small></td>
                        <td>
                            <a href="https://wa.me/<?= preg_replace('/[^0-9]/', '', $plgn['HP']); ?>?text=Halo%20<?= urlencode($plgn['NAMA_PEL']); ?>,%20Kami%20dari%20servis.%20Ada%20yang%20ingin%20kami%20sampaikan."
                                target="_blank"
                                 class="badge bg-success text-white text-decoration-none">
                                WhatsApp
                            </a>
                            <a href="<?= BASEURL; ?>/pelanggan/edit/<?= $plgn['IDPEL']; ?>" class="badge bg-primary text-white text-decoration-none tampilmodaledit" data-bs-toggle="modal" data-bs-target="#forminputplgn" data-idpel="<?= $plgn['IDPEL']; ?>">Edit</a>
                            <a href="<?= BASEURL; ?>/pelanggan/hapus/<?= $plgn['IDPEL']; ?>" class="badge bg-danger text-white text-decoration-none" onclick="return confirm('Yakin mau dihapus?');">Hapus</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<div class="modal fade" id="forminputplgn" tabindex="-1" aria-labelledby="tmbhplgn" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="tmbhplgn">Tambah Data Pelanggan</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formPelanggan" action="<?= BASEURL; ?>/pelanggan/tambah" method="post">
                    <input type="hidden" id="idpel" name="IDPEL">
                    <div class="mb-3">
                        <label for="nama_pel" class="form-label">Nama Pelanggan</label>
                        <input type="text" class="form-control" id="nama_pel" name="NAMA_PEL">
                    </div>
                    <div class="mb-3">
                        <label for="alamat" class="form-label">Alamat</label>
                        <input type="text" class="form-control" id="alamat" name="ALAMAT">
                    </div>
                    <div class="mb-3">
                        <label for="hp" class="form-label">HP</label>
                        <input type="text" class="form-control" id="hp" name="HP">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah Data</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
