<!-- Button trigger modal -->
<div class="container mt-6">
    <!-- Informasi Pelanggan Card -->
    <div class="card shadow-lg" style="width: 25rem;">
        <div class="card-header bg-primary text-white">
            <h5 class="card-title mb-0"><?= $data['plgn']['NAMA_PEL']; ?></h5>
        </div>
        <div class="card-body">
            <h6 class="card-subtitle mb-2 text-muted">ID Pelanggan: <?= $data['plgn']['IDPEL']; ?></h6>
            <p class="card-text"><strong>Alamat:</strong> <?= $data['plgn']['ALAMAT']; ?></p>
            <p class="card-text"><strong>Nomor HP:</strong> <?= $data['plgn']['HP']; ?></p>
            <hr>

            <!-- Grid untuk Tombol Kembali dan Tombol Tambah Data Servis -->
            <div class="row">
                <div class="col-6">
                    <a href="<?= BASEURL; ?>/pelanggan" class="btn btn-primary w-100">Kembali</a>
                </div>
                <div class="col-6">
                    <button type="button" class="btn btn-success w-100 tambahDataServis" data-bs-toggle="modal" data-bs-target="#formservis" data-idpel="<?= $data['plgn']['IDPEL']; ?>">
                        Tambah Data Servis
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal -->
<div class="modal fade" id="formservis" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Tambah Data Servis</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form action="<?= BASEURL; ?>/servis/tambah" method="post">
                    <input type="hidden" id="IDPEL" name="IDPEL">
                    <div class="mb-3">
                        <label for="namabrg" class="form-label">Nama Barang</label>
                        <input type="text" class="form-control" id="namabrg" name="NAMABRG">
                    </div>
                    <div class="mb-3">
                        <label for="TGL" class="form-label">Tanggal</label>
                        <input type="date" class="form-control" id="tgl" name="TGL">
                    </div>
                    <div class="mb-3">
                        <label for="KELUHAN" class="form-label">Keluhan</label>
                        <input type="text" class="form-control" id="keluhan" name="KELUHAN">
                    </div>
                    <label for="STATUS" class="form-label">Status</label>
                        <select class="form-select" name="STATUS" id="status" aria-label="Default select example">
                            <option value="Dikerjakan">Dikerjakan</option>
                            <option value="Ready">Ready</option>
                            <option value="Selesai">Selesai</option>
                        </select>
                    </div>
                    <!-- Tambah input fields lainnya sesuai kebutuhan -->
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah Data</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    // Script JavaScript untuk menangani klik tombol Tambah Data Servis
    document.addEventListener('DOMContentLoaded', function() {
        const tambahDataServisButtons = document.querySelectorAll('.tambahDataServis');
        
        tambahDataServisButtons.forEach(function(button) {
            button.addEventListener('click', function() {
                const idPelanggan = this.getAttribute('data-idpel');
                document.getElementById('IDPEL').value = idPelanggan;
            });
        });
    });
</script>
