<div class="container mt-3">
    <div class="row">
        <div class="col-12 mb-3">
            <?php Flashnotif::notif(); ?>
        </div>
    </div>
    <div class="row">
        <div class="col-12">
            <h4 class="mb-3">Daftar barang</h4>
            <button type="button" class="btn btn-primary mb-3 tambahdatabrg" data-bs-toggle="modal" data-bs-target="#forminputbrg">
                Tambah Data barang
            </button>
            <table id="barangTable" class="display">
                <thead>
                    <tr>
                        <th>Nama barang</th>
                        <th>Harga</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                // Extract IDPEL for sorting
                $idbrg = array_column($data['brg'], 'IDBRG');

                // Sort $data['plgn'] based on $idpel in descending order
                array_multisort($idbrg, SORT_DESC, $data['brg']);
                ?>

                <?php foreach($data['brg'] as $brg) : ?>
                    <tr>
                        <td><strong><?= $brg['NAMA_BRG']; ?></strong></td>
                        <td><small>Rp<?= number_format($brg['HARGA_BRG'], 0, ',', '.'); ?></small></td>
                        <td>
                            <a href="<?= BASEURL; ?>/barang/edit/<?= $brg['IDBRG']; ?>" class="badge bg-success text-white text-decoration-none tampilmodaleditbrg" data-bs-toggle="modal" data-bs-target="#forminputbrg" data-idbrg="<?= $brg['IDBRG']; ?>">Edit</a>
                            <a href="<?= BASEURL; ?>/barang/hapus/<?= $brg['IDBRG']; ?>" class="badge bg-danger text-white text-decoration-none" onclick="return confirm('yakin mau dihapus.?');">Hapus</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table><ul class="list-group">
        </div>
    </div>
</div>

<div class="modal fade" id="forminputbrg" tabindex="-1" aria-labelledby="tmbhbrg" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="tmbhbrg">Tambah Data barang</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body">
                <form id="formbarang" action="<?= BASEURL; ?>/barang/tambah" method="post">
                    <input type="hidden" id="idbrg" name="IDBRG">
                    <div class="mb-3">
                        <label for="NAMA_BRG" class="form-label">Nama barang</label>
                        <input type="text" class="form-control" id="nama_brg" name="NAMA_BRG">
                    </div>
                    <div class="mb-3">
                        <label for="HARGA" class="form-label">HARGA</label>
                        <input type="text" class="form-control" id="harga_brg" name="HARGA_BRG">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Tambah Data</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
