<?php

class servis_model {
    private $tabel = 'servis';
    private $db;

    public function __construct() {
        $this->db = new Database;
    }

    public function getservisAll() {
        $this->db->query('SELECT * FROM ' . $this->tabel);
        return $this->db->resultSet();
    }

    public function getServisById($idServis) {
        $this->db->query("SELECT s.*, p.NAMA_PEL FROM servis s JOIN pelanggan p ON s.IDPEL = p.IDPEL WHERE s.IDSERVIS = :idServis");
        $this->db->bind('idServis', $idServis);
        return $this->db->single();
    }


    public function tambahdatasrv($data) {
        $queryinsert = "INSERT INTO servis ( IDPEL, NAMABRG, TGL, KELUHAN, STATUS) VALUES (:IDPEL, :NAMABRG, :TGL, :KELUHAN, :STATUS)";
        $this->db->query($queryinsert);
        $this->db->bind('IDPEL', $data['IDPEL']);
        $this->db->bind('NAMABRG', $data['NAMABRG']);
        $this->db->bind('TGL', $data['TGL']);
        $this->db->bind('KELUHAN', $data['KELUHAN']);
        $this->db->bind('STATUS', $data['STATUS']);
        // Eksekusi querynya
        $this->db->execute();
        // Panggil method untuk menghitung rownya
        return $this->db->rowCount();
    }
    public function hapusdatasrv($IDSERVIS) {
        try {
            // Lakukan penghapusan dari tabel servis
            $querydelete = "DELETE FROM servis WHERE IDSERVIS=:IDSERVIS";
            $this->db->query($querydelete);
            $this->db->bind('IDSERVIS', $IDSERVIS);
            $this->db->execute();
    
            // Periksa apakah ada baris yang terpengaruh
            $rowCount = $this->db->rowCount();
    
            if ($rowCount > 0) {
                // Berhasil dihapus
                return true;
            } else {
                // Tidak ada baris yang terpengaruh, berikan peringatan atau pesan
                // Misalnya, menggunakan session flash message atau mengembalikan pesan JSON ke client
                $_SESSION['flash'] = [
                    'type' => 'warning',
                    'message' => 'Tidak dapat menghapus data servis karena masih terdapat detail servis yang terkait.',
                ];
                return false;
            }
        } catch (PDOException $e) {
            // Tangani atau log error sesuai kebutuhan aplikasi
            error_log('Error: ' . $e->getMessage());
            // Berikan peringatan atau pesan
            $_SESSION['flash'] = [
                'type' => 'danger',
                'message' => 'Terjadi kesalahan saat menghapus data servis.',
            ];
            return false;
        }
    }
    
    public function ubahdatasrv($data) {
        $queryupdate = "UPDATE servis SET IDPEL =:IDPEL, NAMABRG =:NAMABRG, TGL =:TGL, KELUHAN =:KELUHAN, STATUS =:STATUS WHERE IDSERVIS =:IDSERVIS";
        $this->db->query($queryupdate);
        $this->db->bind('IDPEL', $data['IDPEL']);
        $this->db->bind('NAMABRG', $data['NAMABRG']);
        $this->db->bind('TGL', $data['TGL']);
        $this->db->bind('KELUHAN', $data['KELUHAN']);
        $this->db->bind('STATUS', $data['STATUS']);
        $this->db->bind('IDSERVIS', $data['IDSERVIS']);
        
        // Eksekusi querynya
        $this->db->execute();
    
        // Panggil method untuk menghitung rownya
        return $this->db->rowCount();
    }
    
    public function caridatasrv() {
        $keyword = $_POST['pencarian'];
        $querycari = "SELECT * FROM servis WHERE NAMABRG LIKE :pencarian";
        $this->db->query($querycari);
        $this->db->bind('pencarian', "%$keyword%");
        return $this->db->resultSet();
    }

    public function cetakttbyid($IDSERVIS) {
        $this->db->query('SELECT s.*, p.NAMA_PEL, p.ALAMAT, p.HP 
                          FROM servis s
                          LEFT JOIN pelanggan p ON s.IDPEL = p.IDPEL
                          WHERE s.IDSERVIS = :IDSERVIS');
        $this->db->bind('IDSERVIS', $IDSERVIS);
        return $this->db->single();
    }



    public function getDetailByServisId($idServis) {
        $this->db->query('SELECT ds.*, p.NAMA_PEN FROM detailservis ds
                          JOIN penanganan p ON ds.IDPEN = p.IDPEN
                          WHERE ds.IDSERVIS = :idServis');
        $this->db->bind('idServis', $idServis);
        return $this->db->resultSet();
    }

    public function getPenanganan() {
        $this->db->query("SELECT * FROM penanganan");
        return $this->db->resultSet();
    }

    public function getpelanggan() {
        $this->db->query("SELECT * FROM pelanggan");
        return $this->db->resultSet();
    }

    public function tambahDetailServis($data) {
        $query = "INSERT INTO detailservis (IDSERVIS, IDPEN, BANYAKNYA, JUMLAH) VALUES (:IDSERVIS, :IDPEN, :BANYAKNYA, :JUMLAH)";
        $this->db->query($query);
        $this->db->bind('IDSERVIS', $data['IDSERVIS']);
        $this->db->bind('IDPEN', $data['IDPEN']);
        $this->db->bind('BANYAKNYA', $data['BANYAKNYA']);
        $this->db->bind('JUMLAH', $data['JUMLAH']);
        $this->db->execute();

        return $this->db->rowCount();
    }

    public function tambahPenanganan($data) {
        $query = "INSERT INTO penanganan (IDPEN, NAMA_PEN, HARGA) VALUES (:IDPEN, :NAMA_PEN, :HARGA)";
        $this->db->query($query);
        $this->db->bind('IDPEN', $data['IDPEN']);
        $this->db->bind('NAMA_PEN', $data['NAMA_PEN']);
        $this->db->bind('HARGA', $data['HARGA']);
        $this->db->execute();

        return $this->db->rowCount();
    }
    // Contoh dalam model atau controller, sesuai dengan struktur aplikasi Anda
    public function hapusDetailServis($IDSERVIS, $IDPEN) {
        // Persiapkan query untuk menghapus berdasarkan kombinasi kolom
        $query = "DELETE FROM detailservis WHERE IDSERVIS = :idservis AND IDPEN = :idpen";
        $this->db->query($query);
        $this->db->bind('idservis', $IDSERVIS);
        $this->db->bind('idpen', $IDPEN);
        
        return $this->db->execute(); // Eksekusi query penghapusan
    }


    public function getDetailServisById($IDSERVIS) {
        $this->db->query('
            SELECT ds.*, p.NAMA_PEN, ds.BANYAKNYA * p.HARGA AS JUMLAH
            FROM detailservis ds
            JOIN penanganan p ON ds.IDPEN = p.IDPEN
            WHERE ds.IDSERVIS = :IDSERVIS
        ');
        $this->db->bind('IDSERVIS', $IDSERVIS);
        return $this->db->resultSet();
    }

}
?>
