<?php

class penjualan_model
{
    private $tabel = 'penjualan';
    private $db;

    public function __construct()
    {
        $this->db = new Database;
    }

    public function getBarang()
{
    $this->db->query("SELECT * FROM barang ORDER BY IDBRG DESC");
    return $this->db->resultSet();
}


    public function getPenjualanAll()
    {
        $this->db->query("
            SELECT penjualan.*, pelanggan.NAMA_PEL 
            FROM penjualan
            LEFT JOIN pelanggan ON pelanggan.IDPEL = penjualan.IDPEL
            ORDER BY penjualan.IDPENJ DESC
        ");
        return $this->db->resultSet();
    }

    public function getPenjualanById($IDPENJ)
    {
        $this->db->query("
            SELECT penjualan.*, pelanggan.NAMA_PEL 
            FROM penjualan
            LEFT JOIN pelanggan ON pelanggan.IDPEL = penjualan.IDPEL
            WHERE IDPENJ = :IDPENJ
        ");
        $this->db->bind('IDPENJ', $IDPENJ);
        return $this->db->single();
    }

    public function tambahdatapenj($data)
    {
        $query = "INSERT INTO penjualan (TGLJ, TOTALJ, IDPEL) 
                  VALUES (:TGLJ, :TOTALJ, :IDPEL)";

        $this->db->query($query);
        $this->db->bind('TGLJ', $data['TGLJ']);
        $this->db->bind('TOTALJ', $data['TOTALJ']);
        $this->db->bind('IDPEL', $data['IDPEL']);

        $this->db->execute();
        return $this->db->rowCount();
    }

    public function getDetailByPenjualanId($IDPENJ)
{
    $this->db->query(
        "SELECT detailpenj.*, barang.NAMA_BRG, barang.HARGA_BRG
         FROM detailpenj
         JOIN barang ON detailpenj.IDBRG = barang.IDBRG
         WHERE detailpenj.IDPENJ = :IDPENJ"
    );

    $this->db->bind('IDPENJ', $IDPENJ);

    return $this->db->resultSet();
}


    public function hapusdatapenj($IDPENJ)
    {
        $this->db->query("DELETE FROM penjualan WHERE IDPENJ = :IDPENJ");
        $this->db->bind('IDPENJ', $IDPENJ);

        $this->db->execute();
        return $this->db->rowCount();
    }

    public function ubahdatapenj($data)
    {
        $query = "
            UPDATE penjualan 
            SET TGLJ = :TGLJ, TOTALJ = :TOTALJ, IDPEL = :IDPEL
            WHERE IDPENJ = :IDPENJ
        ";

        $this->db->query($query);
        $this->db->bind('TGLJ', $data['TGLJ']);
        $this->db->bind('TOTALJ', $data['TOTALJ']);
        $this->db->bind('IDPEL', $data['IDPEL']);
        $this->db->bind('IDPENJ', $data['IDPENJ']);

        $this->db->execute();
        return $this->db->rowCount();
    }

    public function tambahDetailpenjualan($data)
{
    $query = "INSERT INTO detailpenj (IDPENJ, IDBRG, BANYAKNYAJ, JUMLAHJ) 
              VALUES (:IDPENJ, :IDBRG, :BANYAKNYAJ, :JUMLAHJ)";
    
    $this->db->query($query);
    $this->db->bind('IDPENJ', $data['IDPENJ']);
    $this->db->bind('IDBRG', $data['IDBRG']);
    $this->db->bind('BANYAKNYAJ', $data['BANYAKNYAJ']);
    $this->db->bind('JUMLAHJ', $data['JUMLAHJ']);
    
    $this->db->execute();
    return $this->db->rowCount();
}

public function hapusDetailpenjualan($IDPENJ, $IDBRG)
    {
        $this->db->query("DELETE FROM detailpenj 
                        WHERE IDPENJ = :IDPENJ AND IDBRG = :IDBRG");
        $this->db->bind('IDPENJ', $IDPENJ);
        $this->db->bind('IDBRG', $IDBRG);
        $this->db->execute();

        return $this->db->rowCount();
    }



    public function caridatapenj()
    {
        $keyword = $_POST['pencarian'];

        $this->db->query("
            SELECT penjualan.*, pelanggan.NAMA_PEL
            FROM penjualan
            JOIN pelanggan ON pelanggan.IDPEL = penjualan.IDPEL
            WHERE pelanggan.NAMA_PEL LIKE :keyword
        ");

        $this->db->bind('keyword', "%$keyword%");
        return $this->db->resultSet();
    }
}
