<?php

class penanganan_model {
    private $tabel = 'penanganan';
    private $db;

    public function __construct() {
        $this->db = new Database;
    }

    public function getpenangananAll() {
        $this->db->query('SELECT * FROM ' . $this->tabel);
        return $this->db->resultSet();
    }

    public function getpenangananbyid($IDPEN) {
        $this->db->query('SELECT * FROM penanganan WHERE IDPEN = :IDPEN');
        $this->db->bind('IDPEN', $IDPEN);
        return $this->db->single();
    }

    public function tambahdatapngn($data) {
        $queryinsert = "INSERT INTO penanganan ( NAMA_PEN, HARGA) VALUES (:NAMA_PEN, :HARGA)";
        $this->db->query($queryinsert);
        $this->db->bind('NAMA_PEN', $data['NAMA_PEN']);
        $this->db->bind('HARGA', $data['HARGA']);
        // Eksekusi querynya
        $this->db->execute();
        // Panggil method untuk menghitung rownya
        return $this->db->rowCount();
    }
    public function hapusdatapngn($IDPEN) {
        try {
            // Lakukan penghapusan dari tabel penanganan
            $querydelete = "DELETE FROM penanganan WHERE IDPEN=:IDPEN";
            $this->db->query($querydelete);
            $this->db->bind('IDPEN', $IDPEN);
            $this->db->execute();
    
            // Periksa apakah ada baris yang terpengaruh
            $rowCount = $this->db->rowCount();
    
            if ($rowCount > 0) {
                // Berhasil dihapus
                return true;
            } else {
                // Tidak ada baris yang terpengaruh, berikan peringatan atau pesan
                // Misalnya, menggunakan session flash message atau mengembalikan pesan JSON ke client
                $_SESSION['flash'] = [
                    'type' => 'warning',
                    'message' => 'Tidak dapat menghapus data karena terdapat ketergantungan foreign key.',
                ];
                return false;
            }
        } catch (PDOException $e) {
            // Tangani atau log error sesuai kebutuhan aplikasi
            error_log('Error: ' . $e->getMessage());
            // Berikan peringatan atau pesan
            $_SESSION['flash'] = [
                'type' => 'danger',
                'message' => 'Terjadi kesalahan saat menghapus data.',
            ];
            return false;
        }
    }
    
    
    public function ubahdatapngn($data) {
        $queryupdate = "UPDATE penanganan SET NAMA_PEN = :NAMA_PEN, HARGA = :HARGA WHERE IDPEN = :IDPEN";
        $this->db->query($queryupdate);
        $this->db->bind('NAMA_PEN', $data['NAMA_PEN']);
        $this->db->bind('HARGA', $data['HARGA']);
        $this->db->bind('IDPEN', $data['IDPEN']);
        // Eksekusi querynya
        $this->db->execute();
        // Panggil method untuk menghitung rownya
        return $this->db->rowCount();
    }
    public function caridatapngn() {
        $keyword = $_POST['pencarian'];
        $querycari = "SELECT * FROM penanganan WHERE NAMA_PEN LIKE :pencarian";
        $this->db->query($querycari);
        $this->db->bind('pencarian', "%$keyword%");
        return $this->db->resultSet();
    }
}
?>
