<?php

class barang_model {
    private $tabel = 'barang';
    private $db;

    public function __construct() {
        $this->db = new Database;
    }

    public function getbarangAll() {
        $this->db->query('SELECT * FROM ' . $this->tabel);
        return $this->db->resultSet();
    }

    public function getbarangbyid($IDBRG) {
        $this->db->query('SELECT * FROM barang WHERE IDBRG = :IDBRG');
        $this->db->bind('IDBRG', $IDBRG);
        return $this->db->single();
    }

    public function tambahdatabrg($data) {
        $queryinsert = "INSERT INTO barang ( NAMA_BRG, HARGA_BRG) VALUES (:NAMA_BRG, :HARGA_BRG)";
        $this->db->query($queryinsert);
        $this->db->bind('NAMA_BRG', $data['NAMA_BRG']);
        $this->db->bind('HARGA_BRG', $data['HARGA_BRG']);
        // Eksekusi querynya
        $this->db->execute();
        // Panggil method untuk menghitung rownya
        return $this->db->rowCount();
    }
    public function hapusdatabrg($IDBRG) {
        try {
            // Lakukan penghapusan dari tabel barang
            $querydelete = "DELETE FROM barang WHERE IDBRG=:IDBRG";
            $this->db->query($querydelete);
            $this->db->bind('IDBRG', $IDBRG);
            $this->db->execute();
    
            // Periksa apakah ada baris yang terpengaruh
            $rowCount = $this->db->rowCount();
    
            if ($rowCount > 0) {
                // Berhasil dihapus
                return true;
            } else {
                // Tidak ada baris yang terpengaruh, berikan peringatan atau pesan
                // Misalnya, menggunakan session flash message atau mengembalikan pesan JSON ke client
                $_SESSION['flash'] = [
                    'type' => 'warning',
                    'message' => 'Tidak dapat menghapus data karena terdapat ketergantungan foreign key.',
                ];
                return false;
            }
        } catch (PDOException $e) {
            // Tangani atau log error sesuai kebutuhan aplikasi
            error_log('Error: ' . $e->getMessage());
            // Berikan peringatan atau pesan
            $_SESSION['flash'] = [
                'type' => 'danger',
                'message' => 'Terjadi kesalahan saat menghapus data.',
            ];
            return false;
        }
    }
    
    
    public function ubahdatabrg($data) {
        $queryupdate = "UPDATE barang SET NAMA_BRG = :NAMA_BRG, HARGA_BRG = :HARGA_BRG WHERE IDBRG = :IDBRG";
        $this->db->query($queryupdate);
        $this->db->bind('NAMA_BRG', $data['NAMA_BRG']);
        $this->db->bind('HARGA_BRG', $data['HARGA_BRG']);
        $this->db->bind('IDBRG', $data['IDBRG']);
        // Eksekusi querynya
        $this->db->execute();
        // Panggil method untuk menghitung rownya
        return $this->db->rowCount();
    }
    public function caridatabrg() {
        $keyword = $_POST['pencarian'];
        $querycari = "SELECT * FROM barang WHERE NAMA_BRG LIKE :pencarian";
        $this->db->query($querycari);
        $this->db->bind('pencarian', "%$keyword%");
        return $this->db->resultSet();
    }
}
?>
