<?php

class Pelanggan_model {
    private $tabel = 'pelanggan';
    private $db;

    public function __construct() {
        $this->db = new Database;
    }

    public function getPelangganAll() {
        $this->db->query('SELECT * FROM ' . $this->tabel);
        return $this->db->resultSet();   
    }
    public function getAllPelanggann() {
        $this->db->query("SELECT * FROM " . $this->tabel . " ORDER BY IDPEL DESC");
        return $this->db->resultSet();
    }

    public function getpelangganbyid($IDPEL) {
        $this->db->query('SELECT * FROM pelanggan WHERE IDPEL = :IDPEL');
        $this->db->bind('IDPEL', $IDPEL);
        return $this->db->single();
    }

    public function tambahdataplgn($data) {
        $queryinsert = "INSERT INTO pelanggan ( NAMA_PEL, ALAMAT, HP) VALUES (:NAMA_PEL, :ALAMAT, :HP)";
        $this->db->query($queryinsert);
        $this->db->bind('NAMA_PEL', $data['NAMA_PEL']);
        $this->db->bind('ALAMAT', $data['ALAMAT']);
        $this->db->bind('HP', $data['HP']);
        // Eksekusi querynya
        $this->db->execute();
        // Panggil method untuk menghitung rownya
        return $this->db->rowCount();
    }
    public function hapusdataplgn($IDPEL) {
        try {
            // Lakukan penghapusan dari tabel pelanggan
            $querydelete = "DELETE FROM pelanggan WHERE IDPEL=:IDPEL";
            $this->db->query($querydelete);
            $this->db->bind('IDPEL', $IDPEL);
            $this->db->execute();
    
            // Periksa apakah ada baris yang terpengaruh
            $rowCount = $this->db->rowCount();
    
            if ($rowCount > 0) {
                // Berhasil dihapus
                return true;
            } else {
                // Tidak ada baris yang terpengaruh, berikan peringatan atau pesan
                // Misalnya, menggunakan session flash message atau mengembalikan pesan JSON ke client
                $_SESSION['flash'] = [
                    'type' => 'warning',
                    'message' => 'Tidak dapat menghapus data pelanggan karena masih terdapat data yang terkait.',
                ];
                return false;
            }
        } catch (PDOException $e) {
            // Tangani atau log error sesuai kebutuhan aplikasi
            error_log('Error: ' . $e->getMessage());
            // Berikan peringatan atau pesan
            $_SESSION['flash'] = [
                'type' => 'danger',
                'message' => 'Terjadi kesalahan saat menghapus data pelanggan.',
            ];
            return false;
        }
    }
    
    public function ubahdataplgn($data) {
        $queryupdate = "UPDATE pelanggan SET NAMA_PEL = :NAMA_PEL, ALAMAT = :ALAMAT, HP =:HP WHERE IDPEL = :IDPEL";
        $this->db->query($queryupdate);
        $this->db->bind(':NAMA_PEL', $data['NAMA_PEL']);
        $this->db->bind(':ALAMAT', $data['ALAMAT']);
        $this->db->bind('HP', $data['HP']);
        $this->db->bind(':IDPEL', $data['IDPEL']);
        // Eksekusi querynya
        $this->db->execute();
        // Panggil method untuk menghitung rownya
        return $this->db->rowCount();
    }
    
    public function caridataplgn() {
        $keyword = $_POST['pencarian'];
        $querycari = "SELECT * FROM pelanggan WHERE NAMA_PEL LIKE :pencarian";
        $this->db->query($querycari);
        $this->db->bind('pencarian', "%$keyword%");
        return $this->db->resultSet();
    }
    public function getNamaPelangganByIDPEL($IDPEL) {
        $this->db->query('SELECT NAMA_PEL FROM pelanggan WHERE IDPEL = :IDPEL');
        $this->db->bind(':IDPEL', $IDPEL);
        $this->db->execute();
        return $this->db->single()['NAMA_PEL'];
    }

}
?>
