<?php

class servis extends Controller{
    private $pelangganModel;
    private $servisModel;
    public function index(){
        $data['judul']='Daftar servis';
        $data['srv']=$this->model('servis_model')->getservisAll();
        $data['pelanggan'] = $this->model('servis_model')->getpelanggan();
        $this->view('templates/header', $data);
        $this->view('servis/index', $data);
        $this->view('templates/footer');
    }
    
    public function __construct() {
        $this->pelangganModel = $this->model('Pelanggan_model'); // Sesuaikan dengan nama model Anda
        $this->servisModel = $this->model('servis_model'); // Pastikan nama model disesuaikan dengan yang Anda gunakan
    }
    public function detail($IDSERVIS){
        $data['judul']='Detail servis';
        $data['srv']=$this->model('servis_model')->getservisbyid($IDSERVIS);
        $this->view('templates/header', $data);
        $this->view('servis/detail', $data);
        $this->view('templates/footer');
    }
    public function tambah(){
        if($this->model('servis_model')->tambahdatasrv($_POST)>0){
            Flashnotif::setFlash('berhasil','ditambah','alert alert-success');
            header('Location:'. BASEURL .'/servis');
            exit;
        }else{
            Flashnotif::setFlash('gagal','ditambah','alert alert-danger');
            header('Location:'. BASEURL .'/servis');
            exit;
        }
    }
    public function hapus($IDSERVIS){
        if($this->model('servis_model')->hapusdatasrv($IDSERVIS)>0){
            Flashnotif::setFlash('berhasil','dihapus','alert alert-success');
            header('Location:'. BASEURL .'/servis');
            exit;
        }else{
            Flashnotif::setFlash('gagal','dihapus','alert alert-danger');
            header('Location:'. BASEURL .'/servis');
            exit;
        }
    }
    public function editsrv(){
        echo json_encode($this->model('servis_model')->getservisbyid($_POST['IDSERVIS']));
        
    }
    public function ubah() {
        if ($this->model('servis_model')->ubahdatasrv($_POST) > 0) {
            Flashnotif::setFlash('berhasil', 'diubah', 'alert alert-success');
            header('Location: ' . BASEURL . '/servis');
            exit;
        } else {
            Flashnotif::setFlash('gagal', 'diubah', 'alert alert-danger');
            header('Location: ' . BASEURL . '/servis');
            exit;
        }
    }
    public function cari(){
        $data['judul']='Daftar servis';
        $data['srv']=$this->model('servis_model')->caridatasrv();
        $this->view('templates/header', $data);
        $this->view('servis/index', $data);
        $this->view('templates/footer');
    }
    
    public function getNamaPelangganByNoHp($HP) {
        return $this->model('Pelanggan_model')->getNamaPelangganByNoHp($HP);
    }
    public function cetaktt($IDSERVIS){
        $data['judul'] = 'Cetak Tanda Terima';
        // Ambil data servis berdasarkan ID servis
        $data['servis'] = $this->model('servis_model')->getServisById($IDSERVIS);
        $data['pelanggan'] = $this->model('Pelanggan_model')->getPelangganById($data['servis']['IDPEL']);
        $this->view('servis/cetaktt', $data);
    }


    public function proses($idServis) {
        $data['judul'] = 'Proses Data Servis';
        $data['servis'] = $this->model('servis_model')->getServisById($idServis);
        $data['detailservis'] = $this->model('servis_model')->getDetailByServisId($idServis);
        $data['penanganan'] = $this->model('servis_model')->getPenanganan();
        $this->view('templates/header', $data);
        $this->view('servis/proses', $data);
        $this->view('templates/footer');
    }

    public function tambahDetail() {
        if ($this->model('servis_model')->tambahDetailServis($_POST) > 0) {
            header('Location: ' . BASEURL . '/servis/proses/' . $_POST['IDSERVIS']);
            exit;
        } else {
            header('Location: ' . BASEURL . '/servis/proses/' . $_POST['IDSERVIS']);
            exit;
        }
    }
    public function tambahPenanganan() {
        if ($this->model('servis_model')->tambahPenanganan($_POST) > 0) {
            header('Location: ' . BASEURL . '/servis/proses/' . $_POST['IDSERVIS']);
            exit;
        } else {
            header('Location: ' . BASEURL . '/servis/proses/' . $_POST['IDSERVIS']);
            exit;
        }
    }
    public function hapusDetailServis() {
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $IDSERVIS = $_POST['IDSERVIS'];
        $IDPEN = $_POST['IDPEN'];

        // Panggil model untuk menghapus detail servis
        if ($this->servisModel->hapusDetailServis($IDSERVIS, $IDPEN)) {
            // Redirect atau lakukan sesuatu setelah berhasil menghapus
            header('Location: ' . BASEURL . '/servis/proses/' . $IDSERVIS);
            exit;
        } else {
            header('Location: ' . BASEURL . '/servis/proses/' . $IDSERVIS);
            exit;
        }
    }else {
        redirect('servis');
        }
    
}
    public function cetakNota($IDSERVIS) {
        $data['servis'] = $this->model('servis_model')->getServisById($IDSERVIS);
        $data['detailservis'] = $this->model('servis_model')->getDetailServisById($IDSERVIS);
        $data['tanggal_sekarang'] = date('Y-m-d');

        $this->view('servis/cetakNota', $data);
    }

    
}    
