<?php

class penjualan extends Controller
{
    private $pelangganModel;
    private $penjualanModel;

    public function __construct()
    {
        $this->pelangganModel = $this->model('Pelanggan_model');
        $this->penjualanModel = $this->model('penjualan_model');
    }

    public function index()
    {
        $data['judul'] = 'Daftar penjualan';
        $data['penj'] = $this->penjualanModel->getPenjualanAll();
        $data['pelanggan'] = $this->pelangganModel->getAllPelanggann();

        $this->view('templates/header', $data);
        $this->view('penjualan/index', $data);
        $this->view('templates/footer');
    }

    public function detail($IDPENJ)
    {
        $data['judul'] = 'Detail penjualan';
        $data['penj'] = $this->penjualanModel->getPenjualanById($IDPENJ);

        $this->view('templates/header', $data);
        $this->view('penjualan/detail', $data);
        $this->view('templates/footer');
    }

    public function tambah()
    {
        if ($this->penjualanModel->tambahdatapenj($_POST) > 0) {
            Flashnotif::setFlash('berhasil', 'ditambah', 'alert alert-success');
        } else {
            Flashnotif::setFlash('gagal', 'ditambah', 'alert alert-danger');
        }
        header('Location: ' . BASEURL . '/penjualan');
        exit;
    }

    public function hapus($IDPENJ)
    {
        if ($this->penjualanModel->hapusdatapenj($IDPENJ) > 0) {
            Flashnotif::setFlash('berhasil', 'dihapus', 'alert alert-success');
        } else {
            Flashnotif::setFlash('gagal', 'dihapus', 'alert alert-danger');
        }
        header('Location: ' . BASEURL . '/penjualan');
        exit;
    }

    public function editpenj()
    {
        echo json_encode($this->penjualanModel->getPenjualanById($_POST['IDPENJ']));
    }

    public function ubah()
    {
        if ($this->penjualanModel->ubahdatapenj($_POST) > 0) {
            Flashnotif::setFlash('berhasil', 'diubah', 'alert alert-success');
        } else {
            Flashnotif::setFlash('gagal', 'diubah', 'alert alert-danger');
        }
        header('Location: ' . BASEURL . '/penjualan');
        exit;
    }

    public function cari()
    {
        $data['judul'] = 'Daftar penjualan';
        $data['penj'] = $this->penjualanModel->caridatapenj();

        $this->view('templates/header', $data);
        $this->view('penjualan/index', $data);
        $this->view('templates/footer');
    }

    public function proses($IDPENJ)
    {
        $data['judul'] = 'Proses Data penjualan';
        $data['penjualan'] = $this->penjualanModel->getPenjualanById($IDPENJ);
        $data['detailpenjualan'] = $this->penjualanModel->getDetailByPenjualanId($IDPENJ);
        $data['barang'] = $this->penjualanModel->getBarang();

        $this->view('templates/header', $data);
        $this->view('penjualan/proses', $data);
        $this->view('templates/footer');
    }

    public function tambahDetail()
    {
        $this->penjualanModel->tambahDetailpenjualan($_POST);
        header('Location: ' . BASEURL . '/penjualan/proses/' . $_POST['IDPENJ']);
        exit;
    }

    public function tambahPenanganan()
    {
        $this->penjualanModel->tambahPenanganan($_POST);
        header('Location: ' . BASEURL . '/penjualan/proses/' . $_POST['IDPENJ']);
        exit;
    }

    public function hapusDetailpenjualan()
        {   
        $IDPENJ = $_POST['IDPENJ'];
        $IDBRG  = $_POST['IDBRG'];

        // panggil method model yang benar
        $this->penjualanModel->hapusDetailpenjualan($IDPENJ, $IDBRG);

        // redirect kembali
        header('Location: ' . BASEURL . '/penjualan/proses/' . $IDPENJ);
        exit;
    }


    public function cetakNota($IDPENJ)
    {
        $data['penjualan'] = $this->penjualanModel->getPenjualanById($IDPENJ);
        $data['detailpenjualan'] = $this->penjualanModel->getDetailByPenjualanId($IDPENJ);
        $data['tanggal_sekarang'] = date('Y-m-d');

        $this->view('penjualan/cetakNota', $data);
    }
}
